﻿using System;
using VRM.Integration.Servicebus.Core;

namespace Vimt.JsonWebToken.Configuration
{
    public class JwtConfiguration : ObjectConfigHandler
    {
        private readonly string _orgName;

        public JwtConfiguration(string orgName)
        {
            _orgName = orgName;
        }
        public JwtConfiguration()
        {
        }

        public JwtConfiguration Current
        {
            get
            {
                var customConfigurationFileReader = new CustomConfigurationFileReader();

                var section = customConfigurationFileReader.GetCustomConfig<JwtConfiguration>(
                    ConfigurationLocation.ConfigDefiningAssemblyPath,
                    ConfigurationLocation.GetConfigFilePath(_orgName),
                    "JwtConfiguration");
                if (section == null)
                    throw new Exception("The IMS Custom Settings configuration section has not been specified");
                return section;
            }
        }
        public bool IMS { get; set; }
    }
}